# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 8
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR8_strategy.txt
# LLM Suggested Fallback: C

def benevolent_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    total_rounds = len(my_history) + 1
    opp_coop_rate = opp_history.count("C") / len(opp_history) if opp_history else 1.0
    
    # Initial Phase: Build trust
    if total_rounds <= 3:
        if "D" in opp_history:
            return "D"
        return "C"
    
    # Mid-Game: Conditional response
    if 4 <= total_rounds <= 7:
        if opp_coop_rate >= 0.75:
            if len(opp_history) >= 2 and opp_history[-2:] == ["D", "D"]:
                return "D"
            return "C"
        elif opp_coop_rate <= 0.6:
            return "D" if random.random() < 0.7 else "C"
        else:
            return "C" if random.random() < 0.6 else "D"
    
    # End-Game: Exploit or minimize losses
    if total_rounds >= 8:
        if opp_coop_rate > 0.7:
            if total_rounds >= 9:
                return "D"
            return "C"
        elif opp_coop_rate < 0.5:
            return "D"
        else:
            return "D" if random.random() < 0.5 else "C"
    
    return "C"